/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.77
        Device            :  PIC16F18313
        Driver Version    :  2.00
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#include "mcc_generated_files/mcc.h"
#include <stdio.h>
#include "i2c-lib.h"

// O[oϐ錾
unsigned long Dist;     // vZʊi[p
unsigned long Count;    // ^C}[2 荞݉

// vg^CsO錾
void GP2Y0E03(void);        // ZT[֐
void TMR2_Interrupt(void);  // ^C}[2荞ݏ֐
void Buz_contin(void);      // uU[֐(A)
void Buz_interm(void);      // uU[֐(Ԍ)

/*
                         Main application
 */
void main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    TMR2_SetInterruptHandler(TMR2_Interrupt);   // ^C}[2 荞ݏ֐̒`
    
    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();

    //     
    LATA = 0;    // uU[OFF,LED
    Count = 0;  // CountZbg    
    
    while (1)
    {
        // Add your application code
        
        GP2Y0E03();     // ZT[֐Ăяo 

    // ZT[m        
        if ((Dist >= 4) && (Dist <= 50)) {
            PIE1bits.TMR2IE = 1;    // ^C}[2 荞݋
            LATA = 0x10;    // uU[OFF,LED()OFF,LED()ON
            
            if (Dist < 30)   // ߐڋ߂̂Ƃ
                Buz_contin();   // uU[ON,LED()ON
        }        

    // ZT[m        
        else {
            PIE1bits.TMR2IE = 0;    // ^C}[2 荞݋֎~
            LATA = 0;    // uU[OFF,LED_OFF
            Count = 0;  // CountZbg
        }                
    }
}

// ZT[֐
void GP2Y0E03(void) {

    unsigned long MSB;  // f[^ 8rbg 0x5E(11:4) i[p
    unsigned long LSB;  // f[^ 4rbg 0x5F(3:0) i[p
   
    i2c_start();    // I2CX^[gRfBVs
    i2c_send_byte(0x80);    // X[uID + 0(ݗv) = 0x80
    i2c_send_byte(0x5E);    // ǂݏo擪AhX(0x5E)
    i2c_stop();     // I2CXgbvRfBVs

    i2c_start();    // I2CX^[gRfBVs
    i2c_send_byte(0x81);    // X[uID + 1(ǂݍݗv) = 0x81

    MSB = i2c_read_byte(1);     // ʃf[^ǂݎACK
    LSB = i2c_read_byte(0);     // ʃf[^ǂݎNACK

    i2c_stop();     // I2CXgbvRfBVs

    // vZ
    Dist = ((MSB*16 + LSB) / 16) / 4;      // Dist [cm]
}

// ^C}[2 荞ݏ֐
void TMR2_Interrupt(void) {

    Count++;    // CountCNg
        
    // ZT[m30o߂    
    if (Count >= 1800) {
        Buz_interm();   // uU[ON(Ԍ),LED(+)_ 
        Count = 0;      // CountZbg 
    }
}

// uU[֐(A)
void Buz_contin(void) {
    LATA = 0x20;    // uU[ON,LED()_,LED()
}

// uU[֐(Ԍ) x10JԂ
void Buz_interm(void) {

    unsigned int i;

    for (i=0; i<10; i++) {   
        LATA = 0x30;    // uU[ON,LED(+)ON
        __delay_ms(100);       

        LATA = 0;    // uU[OFF,LED_OFF    
        __delay_ms(100);      
    }
}

/**
 End of File
*/