/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.77
        Device            :  PIC16F1825
        Driver Version    :  2.00
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#include "mcc_generated_files/mcc.h"
#include <stdio.h>
#include "i2c-lib.h"

// Pin̒`t
#define LATCH RA4   // LATCH - RA4
#define STROBE RA5  // STROBE - RA5 
#define SIN1 RC2    // SIN1 - RC2 
#define SIN2 RC3    // SIN2 - RC3 
#define SIN3 RC4    // SIN3 - RC4
#define CLOCK RC5   // CLOCK - RC5 

// O[oϐ錾
unsigned int LED3[32];      // f[^obt@
unsigned int LED2_16[32];   // LED2f[^Vtgp
unsigned int LED3_16[32];   // obt@f[^Vtgp
unsigned int LED1_Set[32];  // LED1f[^Zbgp
unsigned int LED2_Set[32];  // LED2f[^Zbgp
unsigned int LED3_Set[32];  // obt@f[^Zbgp
unsigned long n;            // 
unsigned long Adrs;         // EEPROMAhXϐ
unsigned long StartAdrs;    // EEPROMǂݏoJnAhX 
unsigned long EndAdrs;      // EEPROMǂݏoIAhX

// vg^Cv錾
void Disp(void);        // \֐
void Shift(void);       // Vtg֐
int Read_Ext_EEPROM(long address);      // OtEEPROM 1oCgǂݏo֐ 

/*
                         Main application
 */
void main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    STROBE = 0;     // 0:_, 1:    
    
    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();  // O[o荞ݗL

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();  // ӊ荞ݗL

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();

    // ϐ
    n = 36;          // ݒ
    StartAdrs = 0;
    EndAdrs = 32 * (n + 1);
    
    while (1)
    {
        // Add your application code
        
        unsigned int i;        

        Adrs = StartAdrs;   // AdrsɃf[^ǂݏoJnAhXݒ
        
        for(i=0; i<32; i++) {
            LED3[i] = Read_Ext_EEPROM(Adrs);   // OtEEPROMtHgf[^LED3obt@ɃRs[
            Adrs++;     // AdrsCNg
        }     

        for(i=0; i<32; i=i+2) {
            LED3_Set[i] = (LED3[i] << 8) | LED3[i+1];   // obt@16rbgLED3_SetɊi[            
        }
     
        Shift();    // Vtg֐Ăяo

        StartAdrs = StartAdrs + 32;     // ̃tHgAhX
        if (StartAdrs > EndAdrs)    // StartAdrsEndAdrsɒB烋[v𔲂       
            break;        
    }
}

void Shift(void)    // Vtg֐
{
    unsigned int i,j;        

    while (1)
    {
        for(j=0; j<16; j++) {

            for(i=0; i<32; i=i+2) {
                LED2_16[i] = (LED2_Set[i] & 0x8000) >> 15;  // LED2_Set̐擪rbg𒊏o15rbgEVtg
                LED3_16[i] = (LED3_Set[i] & 0x8000) >> 15;  // LED3_Set̐擪rbg𒊏o15rbgEVtg
                
                LED1_Set[i] = (LED1_Set[i] << 1) | LED2_16[i];  // 1rbgVtgLED1_Set̖LED2_Set擪rbgZbg   
                LED2_Set[i] = (LED2_Set[i] << 1) | LED3_16[i];  // 1rbgVtgLED2_Set̖LED3_Set擪rbgZbg              
                LED3_Set[i] = LED3_Set[i] << 1;  // obt@1rbgVtg
            }        
            Disp();     // \֐Ăяo       
        }     
        break;
    }
}

void Disp(void)     // \֐
{
    unsigned int BitPos;    // rbgqϐ
    unsigned int i,j,k;     // \pϐ

    for(k=0; k<3; k++) {    // C^[o        

        BitPos = 0x01;      // rbgʎq           

// f[^Zbg            
        for(i=0; i<32; i=i+2) {
             
            for(j=0; j<16; j++) {
               
                if (((LED1_Set[i] >> j) & 1) == 1)      // (LED1_Set)rbg
                    SIN2 = 1;            
                else
                    SIN2 = 0;
  
                if (((LED2_Set[i] >> j) & 1) == 1)      // (LED2_Set)rbg
                    SIN3 = 1;            
                else
                    SIN3 = 0;
      
                if (((BitPos >> j) & 1) == 1)     // crbg 
                    SIN1 = 1;            
                else
                    SIN1 = 0;

                CLOCK = 1;      // rbgZbg            
                CLOCK = 0;                
            }

            BitPos <<= 1;   // rbgq1rbgVtg            
           
            LATCH = 0;      // f[^[X            
            LATCH = 1;           
        }            
    }        
}

int Read_Ext_EEPROM(long address) {     // OtEEPROM 1oCgǂݏo֐

    unsigned int data;

// R}hM    
    i2c_start();    // I2CX^[gRfBVs        
    i2c_send_byte(0xA0);    // Rg[oCgMF1010000+0(R/W bit=0)
    i2c_send_byte((address >> 8) & 0x7F);   // ʃAhX(7rbg)M   
    i2c_send_byte(address);   // ʃAhX(8rbg)M

// f[^ǂݏo    
    i2c_start();    // I2CX^[gRfBVs        
    i2c_send_byte(0xA1);    // Rg[oCgMF1010000+1(R/W bit=1)
    data = i2c_read_byte(0);     // f[^ǂݍ(0FNO ACK)
    i2c_stop();     // I2CXgbvRfBVs

    return(data);
}

/**
 End of File
*/