/*
 * File:   i2c-lib.c   for Microchip PIC XC8 (12F1822, 16F1823, 16F1827)
 */

#include <stdio.h>
#include <stdlib.h>

#include <xc.h>
#include "i2c-lib.h"

#ifndef _XTAL_FREQ
    #define _XTAL_FREQ 16000000
#endif

// I2CoXL
void i2c_enable(void)
{
//    SSP1STAT = 0b10000000;      // Wx[h(100 kHz  1 MHz)̃X[[g䂪
    SSP1STAT = 0b00000000;      // [h(400 kHz)̃X[[g䂪L
//    SSP1ADD = 19;               // I2C Baud rateݒ: 8 MHz / ((SSP1ADD + 1) *4 ) = 100kHz
    SSP1ADD = 9;               // I2C Baud rateݒ: 16 MHz / ((SSP1ADD + 1) *4 ) = 400kHz
    SSP1CON1 = 0b00101000;      // SSPW[L/I2C}X^[[h
}

// I2CoX
void i2c_disable(void){
    SSP1CON1 = 0b00001000;      // SSPW[/I2C}X^[[h
}

// I2C Start Conditions
void i2c_start(void){
    SSP1CON2bits.SEN = 1;       //  Start Condition Enabled bit
    i2c_wait();
}

// I2C Repeat Start Conditions
void i2c_repeat_start(void){
    SSP1CON2bits.RSEN = 1;      //  Start Condition Enabled bit
    i2c_wait();
}

// I2C Stop Conditions
void i2c_stop(void){
    SSP1CON2bits.PEN = 1;       // Stop Condition Enable bit
    i2c_wait();
}

// I2CʐMrW[ԂE܂ő҂
void i2c_wait(void){
    while (( SSP1CON2 & 0x1F ) || ( SSP1STATbits.R_nW ));
}

// I2CoXɃf[^𑗐M(oCg)
void i2c_send_byte(const unsigned char data){
    SSP1BUF = data;
    i2c_wait();
}

// I2CoXf[^M
// ack=1 : MACK𑗐MÃf[^𑗂悤X[ufoCXɎw
// ack=0 : MNO_ACK𑗐MAȏMȂƂX[ufoCXɎw
unsigned char i2c_read_byte(const char ack){
    SSP1CON2bits.RCEN = 1;
    i2c_wait();
    unsigned char data = SSP1BUF;
    i2c_wait();

    if(ack) SSP1CON2bits.ACKDT = 0;     // ACK
    else SSP1CON2bits.ACKDT = 1;        // NO_ACK

    SSP1CON2bits.ACKEN = 1;

    i2c_wait();
    return data;
}

