/**
  Generated Main Source File
    Joystick control RCSM in CLC
  
  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.77
        Device            :  PIC16F18424
        Driver Version    :  2.00
 
 I/O Information 
    RC2 - CLC2_OUT(RCT[{[^[ X:Tilt)
    RC3 - CLC4_OUT(RCT[{[^[ Y:Pan)
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#include "mcc_generated_files/mcc.h"

#define XCenter 2048                 // WCXeBbN XZ^[l
#define YCenter 2048                 // WCXeBbN YZ^[l
#define Neutral 1000                 // s
#define XMax 1023                    // f[eB(X:Tilt) 
#define XMin 700                     // f[eB(X:Tilt) 
#define YMax 1023                    // f[eB(Y:Pan) 
#define YMin 450                     // f[eB(Y:Pan) 

// O[oϐ錾
unsigned int XDuty, YDuty;          // f[eB(X,Y)
unsigned long XADC, YADC;           // ADϊl(X,Y)

/*
                         Main application
 */
void main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    //INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();

// ϐ    
    XDuty = 737;            // RCT[{[^[(X)Z^[̃f[eBl   
    YDuty = 737;            // RCT[{[^[(Y)Z^[̃f[eBl

    while (1)
    {
        // Add your application code

// f[eBZbg
        PWM6_LoadDutyValue(XDuty);          // X
        PWM7_LoadDutyValue(YDuty);          // Y                
       
// |eV[^(WCXeBbN)oADϊ       
        XADC = ADCC_GetSingleConversion(channel_ANA5);    // ADC(X)ϊʓǂݏo 
        YADC = ADCC_GetSingleConversion(channel_ANA4);    // ADC(Y)ϊʓǂݏo

// RCT[{ X        
        if(XADC > XCenter + Neutral) {      // ADC(X) > s Ȃ
            XDuty++;                        // f[eBX JEgAbv

            if(XDuty >= XMax)               // f[eBX >=  Ȃ
                XDuty = XMax;               // f[eBX = l
        }
      
        if(XADC < XCenter - Neutral) {      // ADC(X) < s Ȃ
            XDuty--;                        // f[eBX JEg_E
            
            if(XDuty <= XMin)               // f[eBX >=  Ȃ
                XDuty = XMin;               // f[eBX = l
        }        

// RCT[{ Y        
        if(YADC > YCenter + Neutral) {      // ADC(Y) > s Ȃ
            YDuty++;                        // f[eBY JEgAbv

            if(YDuty >= YMax)               // f[eBY >=  Ȃ
                YDuty = YMax;               // f[eBY = l
        }
        
        if(YADC < YCenter - Neutral) {      // ADC(Y) < s Ȃ
            YDuty--;                        // f[eBY JEg_E
            
            if(YDuty <= YMin)               // f[eBY >=  Ȃ
                YDuty = YMin;               // f[eBY = l
        }              

        __delay_ms(15);                     // C^[o

    }
}

/**
 End of File
*/
