/***********************************************
*  t\탉Cu
*  I2CC^[tF[X
*    lcd_init()    ----- 
*    lcd_cmd(cmd)  ----- R}ho
*    lcd_data(data) ----- P\o
*    lcd_str(ptr)  ----- \o
*    lcd_clear()   ----- S
**********************************************/
#include <xc.h>
#include "lcd_lib2.h"
#include "i2c_lib2.h"

/*********************************
* t1\f[^o
*********************************/
void lcd_data(unsigned char data)
{
    CmdI2C(0x7C, 0x40, data);
    __delay_us(30);				// u҂
}

/*******************************
* tւPR}ho
*******************************/
void lcd_cmd(unsigned char cmd)
{
    CmdI2C(0x7C, 0x00, cmd);
    /* ClearHome */
    if((cmd == 0x01)||(cmd == 0x02))
        __delay_ms(2);			// 2msec҂
    else
        __delay_us(30);			// 30usec҂
}

/*******************************
*  ֐
*******************************/
void lcd_init(void)
{
    __delay_ms(100);
    lcd_cmd(0x38);              // 8bit 2line Normal mode
    lcd_cmd(0x39);              // 8bit 2line Extend mode
    lcd_cmd(0x14);              // OSC 183Hz BIAS 1/5
    lcd_cmd(0x70);              // Contrast set for 3.3V  0x70
    lcd_cmd(0x55);              // Power/ICON/Contrast control  0x56
    lcd_cmd(0x6A);			// Follower for 5.0V
//    lcd_cmd(0x6C);              // Follower for 3.3V
    __delay_ms(300);
    lcd_cmd(0x38);              // Set Normal mode
    lcd_cmd(0x0C);              // Display On
    lcd_cmd(0x01);              // Clear Display
}

/******************************
* S֐
******************************/
void lcd_clear(void)
{
    lcd_cmd(0x01);              // R}ho
}

/*****************************
* \֐
*****************************/
void lcd_str(const unsigned char* ptr)
{
    while(*ptr != 0)			// o
        lcd_data(*ptr++);		// \
}

/*****************************
*  ACR\֐
*****************************/
void lcd_icon(unsigned char num, unsigned char onoff)
{
    lcd_cmd(0x39);              // Extend mode
    lcd_cmd(0x40 | ICON[num][0]);	// ACRAhXw
    if(onoff)
        lcd_data(ICON[num][1]);     // ACRIf[^
    else
        lcd_data(0x00);         // ACRItf[^
    lcd_cmd(0x38);              // Normal Mode
}
