/******************************************
*  I2CʐMCu
******************************************/
#include <xc.h>
#include "i2c_lib2.h"

/*************************************
* I2CoXgăf[^M
**************************************/
void SendI2C(unsigned Adrs, unsigned char Data)
{
    IdleI2C();
    SSP1CON2bits.SEN = 1;   		// X^[go
    while(SSP1CON2bits.SEN);		// X^[gI҂
    SendByte(Adrs);                 // AhX{M[hM
    SendByte(Data);                 // R}hf[^M
    SSP1CON2bits.PEN = 1;   		// Xgbvo
    while(SSP1CON2bits.PEN);		// XgbvI҂
}

/****************************************
* I2CoXgăR}hM
*****************************************/
void CmdI2C(unsigned Adrs, unsigned Reg, unsigned char Data)
{
    IdleI2C();
    SSP1CON2bits.SEN = 1;   		// X^[go
    while(SSP1CON2bits.SEN);		// X^[gI҂
    SendByte(Adrs);                 // AhX{M[hM
    SendByte(Reg);                  // WX^w著M
    SendByte(Data);                 // R}hf[^M
    SSP1CON2bits.PEN = 1;   		// Xgbvo
    while(SSP1CON2bits.PEN);		// XgbvI҂
}

/** ACh҂Tu֐ ***/
void IdleI2C(void){
    while(SSP1CON2bits.SEN || SSP1CON2bits.PEN || SSP1CON2bits.RCEN
            || SSP1CON2bits.ACKEN || SSP1STATbits.R_nW);
}

/****************************************
* I2C1oCgM
*****************************************/
void SendByte(unsigned char ch){
    SSP1BUF = ch;                   // f[^ZbgMJn
    while(SSP1STATbits.BF);         // MI҂
    while(SSP1CON2bits.ACKSTAT);    // ACKԐM҂
    IdleI2C();                      // ACh҂    
}

/*****************************************
* I2CoXgnoCgM
******************************************/
void GetDataI2C(unsigned char Adrs, unsigned char *Buffer, unsigned char Cnt)
{
    unsigned char i;

    IdleI2C();                      // ACh҂
    SSP1CON2bits.SEN = 1;   		// X^[go
    while(SSP1CON2bits.SEN);		// X^[gI҂
    SendByte(Adrs+1);               // AhX{M[hM    
    for(i=0; i<Cnt; i++)
        Buffer[i] = RcvByte(0);     // 1oCgM ACK
    Buffer[i] = RcvByte(1);         // ŏIoCgM NACK
    SSP1CON2bits.PEN = 1;   		// Xgbvo
    while(SSP1CON2bits.PEN);		// XgbvI҂
}

/****************************************
* I2C1oCgM ACK/NACK ԑ
*****************************************/
unsigned char RcvByte(unsigned char Ans){
    unsigned char data;
    
    SSP1CON2bits.ACKDT = Ans;		// ACK(0)/NACK(1)ݒ
    SSP1CON2bits.RCEN = 1;          // M RCENZbg
    while(!SSP1STATbits.BF);        // M҂ BF`FbN
    SSP1CON2bits.ACKEN = 1;         // ACKԐM
    data = SSP1BUF;                 // Mf[^擾
    SSP1CON1bits.SSPOV = 0;         // G[NA
    IdleI2C();                      // ACh҂
    return(data);                   // Mf[^Ԃ
}